<?php 
include 'koneksi.php';
include 'header1.php';

// **Ambil Data dari Database**
$bobot = query("SELECT * FROM bobot1");
$alternatif = query("SELECT * FROM mahasiswa");

// **Definisi Nama Kriteria**
$kriteria_nama = [
    "c1" => "Relevansi Konten",
    "c2" => "Kualitas Penyampaian",
    "c3" => "Kualitas Audiovisual",
    "c4" => "Interaktivitas & Engagement",
    "c5" => "Frekuensi Penggunaan",
    "c6" => "Hambatan Akses",
    "c7" => "Dampak terhadap Pemahaman"
];

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-3 bg-light rounded" style="font-size: 28px"><strong>DATA BOBOT KRITERIA DAN NILAI ALTERNATIF</strong></h2>

            <!-- **Tabel Bobot Kriteria** -->
            <div class="card shadow-sm w-100 mt-4">
                <div class="card-header bg-primary text-white text-center align-middle">
                    <h4><i class="fas fa-balance-scale"></i>  Kriteria dan Bobot</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($bobot)) : ?>
                        <div class="table-responsive">
                            <table class="table table-bordered text-center w-100">
                                <thead class="table-primary">
                                    <tr>
                                        <th>Kode Kriteria</th>
                                        <th>Nama Kriteria</th>
                                        <th>Bobot</th>
                                    </tr>
                                </thead>
                                <tbody class="table-light">
                                    <?php foreach ($bobot[0] as $key => $value) : ?>
                                        <?php if (isset($kriteria_nama[$key])) : ?>
                                            <tr>
                                                <td class="align-middle"><?= strtoupper($key); ?></td>
                                                <td class="align-middle"><?= $kriteria_nama[$key]; ?></td>
                                                <td class="align-middle"><?= $value; ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Data tidak tersedia!</div>
                    <?php endif; ?>
                </div>
            </div>
            </div>
            <br>

            <!-- **Tabel Data Alternatif** -->
            <div class="card shadow-sm w-100 mt-4">
                <div class="card-header bg-primary text-white text-center align-middle">
                    <h4><i class="fas fa-table"></i>  Nilai Alternatif</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($alternatif)) : ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover w-100">
                                <thead class="table-primary text-center">
                                    <tr>
                                        <th style="width: 5%;">No.</th>
                                        <?php foreach ($alternatif[0] as $key => $value) : ?>
                                            <?php if (!in_array($key, ['id', 'nama', 'nim', 'email'])) : ?>
                                                <th><?= strtoupper($key); ?></th>
                                            <?php endif; ?>
                                        <?php endforeach; ?>

                                    </tr>
                                </thead>
                                <tbody class="table-light text-center">
                                    <?php $no = 1; ?>
                                    <?php foreach ($alternatif as $row) : ?>
                                        <tr>
                                            <td class="align-middle"><?= $no++; ?></td>
                                            <?php foreach ($row as $key => $value) : ?>
                                                <?php if (!in_array($key, ['id', 'nama', 'nim', 'email'])) : ?>
                                                    <td class="align-middle"><?= $value; ?></td>
                                                <?php endif; ?>
                                            <?php endforeach; ?>

                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Data efektivitas tidak tersedia!</div>
                    <?php endif; ?>
                    <br><br>
                </div>
                           <!-- **Tombol Mulai Proses Perhitungan** -->
                <div class="text-center">
                    <a href="proses1.php" class="btn btn-lg btn-outline-success">
                        <i class="fas fa-calculator"></i> Mulai Proses Perhitungan
                    </a>
                </div>
                <br><br>
                </div>  
        <br><br>
        <br><br>

    </main>
</div>

<!-- 🔥 Pastikan navigasi bisa dibuka dan tidak macet -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>

